*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: PhosmetOxon                              *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";

libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";


/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/

data PhosmetOxon;
     set epa.PhosmetOxon_avg;
run;
proc sort data=PhosmetOxon;
     by id;
run;

/*
ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhosmetOxon - individual sample curves.resids.rtf" startpage=no;
%scatter_plot(chemical=PhosmetOxon);
ods rtf close;
*/

*===> Human vs. Rat;


title "Human vs. Rat: final model 2";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=PhosmetOxon  /* method=firo */ tech=newrap lis=3 maxiter=20000;
      PARMS ha=0.1 0.5 0.9 hb1=0.1 0.5 0.9
			ra=0.1 0.5 0.9 rb1=0.1 0.5 0.9
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best= 50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
			hb=hb1*10;
			rb=rb1*10;
            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-6 + H_I__M + rrb*Rat*1e-6 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  ua ub ~ normal([0, 0],	[gha, 
												 		 ghab, ghb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
	  Predict PRED2 out=Resid_HR;
run;

%let factor=0.001;


ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhosmetOxon human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=PhosmetOxon, model=2)
ods rtf close;


*===> Adult vs. Infant;

title "final model 2 - Adult (>=10 yr) vs. Infant";

		ods output ParameterEstimates=parm_AI;
	 PROC NLMIXED data=PhosmetOxon(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=0.1 0.5 0.9	adb=0.1 0.5 0.9
			ia=0.1 0.5 0.9 ib=0.1 0.5 0.9
			ga1=0.1 0.5 0.9	ga12=0.1 0.5 0.9	ga2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best=50;
			gada=ga1*ga1;
			gadab=ga1*ga12;
			gadb=ga12*ga12+ga2*ga2/100;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-5 + H_I__M*adult + rib*1e-5*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);

     RANDOM  uha uhb ~ normal([0, 0],   [gada, 
														gadab, gadb]) SUBJECT=ID out=RandID_AI;
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
   	  estimate "gada" ga1*ga1;
	  estimate "gadab" ga1*ga12;
	  estimate "gadb" ga12*ga12+ga2*ga2/100;
	  id pred2;
	   predict pred2 out=Resid_AI;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhosmetOxon Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=PhosmetOxon, model=2)
ods rtf close;

*===> Male vs. Female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=PhosmetOxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000 method=firo;
      PARMS ma=0.1 0.5 0.9 mb= 0.1 0.5 0.9
			fa=0.1 0.5 0.9 fB=0.1 0.5 0.9
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best=50;
			gha=gh1*gh1/100;
			ghab=gh1*gh12/100;
			ghb=gh12*gh12/100+gh2*gh2/100;
            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
           PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-5 + H_I__M*male + rfb*female*1e-5 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
  	  estimate "gha" gh1*gh1/100;
	  estimate "ghab" gh1*gh12/100;
	  estimate "ghb" gh12*gh12/100+gh2*gh2/100;
	  id pred2;
	  predict pred2 out=Resid_MF;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhosmetOxon Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=PhosmetOxon, model=2)
ods rtf close;


*===> Caucasian vs. Other Races;

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=PhosmetOxon(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=0.1 0.5 0.9 cb=0.1 0.5 0.9
			ora=0.1 0.5 0.9 orB=0.1 0.5 0.9
			gc1=0.1 0.5 0.9 gc12=0.1 0.5 0.9 gc2=0.1 0.5 0.9
			gor1=0.1 0.5 0.9 gor12=0.1 0.5 0.9 gor2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best=50;
			gca=gc1*gc1/100;
			gcab=gc1*gc12/100;
			gcb=gc12*gc12/100+gc2*gc2/100;
			gora=gor1*gor1/100;
			gorab=gor1*gor12/100;
			gorb=gor12*gor12/100+gor2*gor2/100;
            rca=ca+uca;
			rora=ora+uora;
            rcb=cB+ucb;
			rorb=orB+uorb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
  RANDOM  uca ucb uora uorb ~ normal([0, 0, 0, 0],   [gca, 
														gcab, gcb, 
														0,    0,     gora, 
														0,    0,     gorab,   gorb]) SUBJECT=ID out=RandID_CO; 
		ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasain ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  estimate "gca" gc1*gc1/100;
	  estimate "gcab" gc1*gc12/100;
	  estimate "gcb" gc12*gc12/100+gc2*gc2/100;
  	  estimate "gora" gor1*gor1/100;
	  estimate "gorab" gor1*gor12/100;
	  estimate "gorb" gor12*gor12/100 +gor2*gor2/100;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhosmetOxon Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=PhosmetOxon, model=3)
ods rtf close;

%resids